/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminElementInLogTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementInQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;

public abstract class VWAdminElementTableModel
extends VWAdminResultTableModelBase {
    protected abstract void startTheQuery() throws Exception;

    protected abstract void retrieveElements() throws Exception;

    protected abstract void getExposedFieldsDefinition() throws Exception;

    protected abstract void buildAvailableColumnsList();

    protected abstract void retrieveRowData();

    protected abstract void buildObjectCache();

    public VWAdminElementTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        super(resultsPane, event);
    }

    public Class getColumnClass(int index) {
        if (index == COL_DUE_STATUS) {
            return ImageIcon.class;
        }
        return String.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getCellElement(rowIndex, columnIndex);
    }

    public Object getObjectAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            if (columnIndex == 0 || columnIndex == COL_DUE_STATUS) {
                return rowData.elementAt(columnIndex);
            }
            VWAdminFieldsTableData fieldData = (VWAdminFieldsTableData)rowData.elementAt(columnIndex);
            return fieldData;
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setCellElement(aValue, rowIndex, columnIndex);
    }

    protected Object getCellElement(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            if (columnIndex == 0 || columnIndex == COL_DUE_STATUS) {
                return rowData.elementAt(columnIndex);
            }
            VWAdminFieldsTableData fieldData = (VWAdminFieldsTableData)rowData.elementAt(columnIndex);
            if (fieldData != null) {
                return fieldData.getValue();
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void getNextBatch() throws Exception {
        this.retrieveElements();
        if (!(this instanceof VWAdminElementInLogTableModel)) {
            this.buildObjectCache();
        }
        this.buildAvailableColumnsList();
        this.retrieveColumnNames();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void refreshTable() {
        try {
            this.retrieveColumnNames();
            this.retrieveRowData();
            this.fireTableChanged(new TableModelEvent(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    protected void initTable() throws Exception {
        if (!this.validateIndex()) {
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), VWResource.s_F_WobNumError, VWResource.s_F_WobNumIndex, 0);
            return;
        }
        this.startTheQuery();
        this.getFirstBatch();
    }

    protected void getFirstBatch() throws Exception {
        this.retrieveElements();
        if (!(this instanceof VWAdminElementInLogTableModel)) {
            this.buildObjectCache();
        }
        this.buildAvailableColumnsList();
        this.buildSelectedColumnsList();
        this.retrieveColumnNames();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void setCellElement(Object aValue, int rowIndex, int columnIndex) {
    }

    protected void retrieveColumnNames() {
        try {
            if (this.m_headers != null) {
                this.m_headers.removeAllElements();
            }
            if (this.m_objectCache.size() <= 0) {
                return;
            }
            this.m_startIndex = 0;
            if (this.m_selectedColumns.size() > 0) {
                this.m_headers.addElement(" ");
                ++this.m_startIndex;
            }
            if (this instanceof VWAdminElementInQueueTableModel && this.isInExposedFieldDefinitions("F_Overdue", this.m_vwFieldDefinitions)) {
                this.m_headers.addElement(" ");
                ++this.m_startIndex;
            }
            for (int i = 0; i < this.m_selectedColumns.size(); ++i) {
                this.m_headers.addElement((String)this.m_selectedColumns.elementAt(i));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void buildSelectedColumnsList() {
        try {
            int i;
            this.m_selectedColumns.removeAllElements();
            if (this.m_selectedColumnsFromQuery != null) {
                for (i = 0; i < this.m_selectedColumnsFromQuery.length; ++i) {
                    if (!this.isInVector(this.m_selectedColumnsFromQuery[i], this.m_availableColumns)) continue;
                    this.m_selectedColumns.addElement(this.m_selectedColumnsFromQuery[i]);
                }
            }
            for (i = 0; i < this.m_availableColumns.size(); ++i) {
                VWDataField fieldDef;
                String aField = (String)this.m_availableColumns.elementAt(i);
                if (this.isInVector((String)this.m_availableColumns.elementAt(i), this.m_selectedColumns) || this.isInExposedFieldDefinitions(aField, this.m_vwFieldDefinitions) || (fieldDef = this.getDataField(aField, this.m_availableFields)) == null) continue;
                String authoredName = fieldDef.getAuthoredName();
                String smallString = authoredName.substring(0, 2);
                if (VWStringUtils.compareIgnoreCase(smallString, "F_") != 0) {
                    this.m_selectedColumns.addElement(this.m_availableColumns.elementAt(i));
                    continue;
                }
                if (VWStringUtils.compare(authoredName, "F_Originator") == 0 || VWStringUtils.compare(authoredName, "F_WobNum") == 0 || VWStringUtils.compare(authoredName, "F_WorkFlowNumber") == 0 || VWStringUtils.compare(authoredName, "F_BoundUser") == 0 || VWStringUtils.compare(authoredName, "F_LockUser") == 0 || VWStringUtils.compare(authoredName, "F_StartTime") == 0 || VWStringUtils.compare(authoredName, "F_Subject") == 0 || VWStringUtils.compare(authoredName, "F_Operation") == 0 || VWStringUtils.compare(authoredName, "F_Comment") == 0 || VWStringUtils.compare(authoredName, "F_Response") == 0 || VWStringUtils.compare(authoredName, "F_LockTime") == 0) {
                    this.m_selectedColumns.addElement(this.m_availableColumns.elementAt(i));
                }
                if (!(this instanceof VWAdminElementInLogTableModel) || VWStringUtils.compare(authoredName, "F_BoundUserId") != 0 && VWStringUtils.compare(authoredName, "F_EventType") != 0 && VWStringUtils.compare(authoredName, "F_SeqNumber") != 0 && VWStringUtils.compare(authoredName, "F_OperationId") != 0) continue;
                this.m_selectedColumns.addElement(this.m_availableColumns.elementAt(i));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void switchTableType() {
        this.buildObjectCache();
        this.buildAvailableColumnsList();
        this.buildSelectedColumnsList();
        this.retrieveColumnNames();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }
}

